package com.ejie.aa17a.service.impl.comun;

import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.ejie.aa17a.dao.iface.comun.Aa17aComboDao;
import com.ejie.aa17a.model.comun.Aa17aCombo;
import com.ejie.aa17a.service.iface.comun.Aa17aComboService;

/**
 * Aa17aComboServiceImpl generated by UDA, 18-dic-2013 15:36:14.
 * 
 * @author UDA
 */

public class Aa17aComboServiceImpl implements Aa17aComboService {

	private static final Logger logger = LoggerFactory.getLogger(Aa17aComboServiceImpl.class);

	private Aa17aComboDao Aa17aComboDao;

	/**
	 * Obtiene la lista de estaciones para cargar un combo.
	 * 
	 * @return List<Aa17aCombo>
	 */
	public List<Aa17aCombo> findComboEstaciones() {
		return this.Aa17aComboDao.findComboEstaciones();
	}

	/**
	 * Obtiene la lista de contaminantes de una estacion
	 * 
	 * @param idEstacion
	 *            Long
	 * @return List<Aa17aCombo>
	 */
	public List<Aa17aCombo> findComboContaminantesEstacion(Long idEstacion) {
		return this.Aa17aComboDao.findComboContaminantesEstacion(idEstacion);
	}

	/**
	 * Setter method for Aa17aComboDao.
	 * 
	 * @param Aa17aComboDao
	 *            Aa17aComboDao
	 * @return
	 */
	public void setAa17aComboDao(Aa17aComboDao Aa17aComboDao) {
		Aa17aComboServiceImpl.logger.info("Setting Dependency " + Aa17aComboDao);
		this.Aa17aComboDao = Aa17aComboDao;
	}
}
